/************************************************************************
 * \file: trace_be_common.h
 *
 * \version: $Id: 
 *
 * This file has the API declarations defined in trace_common.c .
 *
 * \component: Gen2 Trace
 *
 * \author Jayanth.MC    Jayanth.MC(o)in.bosch.com
 *
 * \copyright: (c) 2003 - 2012 ADIT
 *
 ***********************************************************************/

#ifndef __TRACE_BE_COMMON_H__
 #define __TRACE_BE_COMMON_H__

/**
* Check for Buffer Overwritten case, and send the info to TTFis
*
* \parm mgr        pointer to Trace manager
* \parm fp         pointer to a io func
* \parm ovrcnt     no of bytes overwritten
* return           None
*/
IMPORT void TRACE_snd_ovrcnt_info_dlt(TRACE_mgr* mgr, U32 ovrcnt);

/**
 * Write data to DLT
 *
 * \parm mgr  Pointer to Trace manager
 * \parm curq Pointer to current packet
 *
 * return \li E_OK     If successful
 *        \li E_IO     In case of socket errors
 *        \li E_DISWAI In case of shutdown request
 *                     Else error returned by concrete implementation
 */
IMPORT ER TRACE_dlt_wr(TRACE_mgr* mgr, TRACE_q* curq);

IMPORT  VP TRACE_sendcmd_task(VP exinf);

/**
* Enable or Disable all class configuration
*
* \parm mgr Pointer to Trace manager
* \parm flag 1= Enable, 0= Disable
*
* return None
*/
IMPORT void TRACE_cfg_ena_all(TRACE_mgr* mgr, BOOL flag);

/**
* Stop trace class/level
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_reset_cnfg(TRACE_mgr* mgr);

/**
* Set trace class/level
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_set_cnfg(TRACE_mgr* mgr);

/**
* Set Trace class grp
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_set_clasgrp(TRACE_mgr* mgr);

/**
* reset Trace class grp
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_reset_clasgrp(TRACE_mgr* mgr);

/**
* Initiate IO device switching
*
* \parm mgr Pointer to Trace manager
*
* return None
*/
IMPORT void TRACE_chg_iodev(TRACE_mgr* mgr);

/**
* This function handles cleaning up.
*
* \parm handler  Pointer to Trace manager
* return \li None
*/
IMPORT void TRACE_cleanup_hdlr(void* handler);

/*@CJH1KOR: Trace configuration command implementation
*
* report all enabled TTFis & proxy classes for trace_out*/
IMPORT void TRACE_send_enabled_class_info(TRACE_mgr* mgr, BOOL trace_class);
/*report trace settings*/
IMPORT void TRACE_send_trace_settings(TRACE_mgr* mgr );
/*report proxy settings*/
IMPORT void TRACE_send_proxy_settings(TRACE_mgr* mgr );
/*report trace registered class info*/
IMPORT void TRACE_send_reg_chnl_info (TRACE_mgr* mgr );
/*@CJH1KOR: Trace configuration command implementation*/

/**
* Save trace configuration
*
* \param  mgr pointer to trace manager
*
* \return E_OK if successful
*              else error returned by concrete implementation
*/
IMPORT ER TRACE_save_cfg(TRACE_mgr* mgr);



IMPORT ER TRACE_exec_notify_evt(TRACE_notify_evt evt, VP payld);

/**
* Process Trace sub-commands
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_process_trace_subcmd(TRACE_mgr* mgr);

/**
* Process platform specific sub-commands
*
* \parm mgr Pointer to Trace manager
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_process_plat_subcmd(TRACE_mgr* mgr);

/**
* Pop message from trace_q and status_q, in an alternate fashion and write
* the message to IO device.
*
* \parm mgr        Pointer to Trace manager
* \parm chk_stat_q This variable indiactes if status Q should be additonally
*                  checked
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
IMPORT ER TRACE_check_q(TRACE_mgr* mgr, S32 chk_stat_q);

/**
* Pop packet from trace_Q and write to IO device
*
* \param stacd Unused
* \parm  exinf Pointer to trace manager info
*
* return None
*/
IMPORT VP TRACE_wr_task(VP exinf);

/**
* Trace Channel Task
*
* \param  stacd   Unused
*         exinf   Pointer to trace manager
*
* \return None
*/
IMPORT VP TRACE_chan_task(VP exinf);

/**
* Trace Proxy Task
*
* \param  stacd   Unused
*         exinf   Pointer to trace manager
*
* \return None
*/
IMPORT VP TRACE_proxy_task(VP exinf);

/**
* Read trace configuration
*
* \param  mgr pointer to Trace manager
*
* \return E_OK if successful
*              else error returned by concrete implementation
*/
IMPORT ER TRACE_rd_cfg(TRACE_mgr* mgr);

IMPORT ER TRACE_cond_uninit(TRACE_cond* pSyncData);

IMPORT ER TRACE_cond_init(TRACE_cond* pSyncData);

/**
* signal handler
* handles SIGTERM and SIGINT signals
*
* \parm  sig signum
*
* return \li none
*/
IMPORT void TRACE_signal_hdlr(S32 sig);

/**
*Function to demonize
*parm none
*return 0 (Normal return)
*/
IMPORT void TRACE_daemonize(void);

/**
* TRACE Check Process
*This function Check whether any other instance of process is already started, if started dont proceed.
*
* \parm  prc 
*
* return pid
*/
/*SWGIII-3516:TRACE startup with Invalid configuration fails */
IMPORT pid_t TRACE_check_process(const char* prc);
#define TRACEBE "trace_be"
#define TRACEDLT "trace_dlt_be"
#endif
